package parser;

/**
 * Factory for S grammar non-terminal objects.
 */
public class SFact extends ATVFactory {
    /**
     * Factory for T grammar non-terminals.
     */
    private TFact _tFac;

    /**
     * Factory for P grammar terminals.
     */
    private PFact _pFac;

    /**
     * Constructor for the E1 factory,
     *
     * @param tkz  tokenizer to use
     * @param tFac factory for T non-terminals
     * @param pFac factory for P non-terminals
     */
    public SFact(ITokenizer tkz, TFact tFac, PFact pFac) {
        super(tkz);
        _tFac = tFac;
        _pFac = pFac;

    }

    /**
     * Make a token visitor to parse an E1 non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _tFac.makeChainedVisitor(_pFac.makeVisitor());
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _tFac.makeChainedVisitor(_pFac.makeChainedVisitor(successor));
    }
}

